<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Debug extends AdminController
{
    public function index()
    {
        if (!is_admin()) {
            access_denied('Workshop Doctor');
        }

        $CI = &get_instance();
        $data['title'] = 'Workshop Doctor';
        
        // 1. Check Database Tables
        $tables = [
            'wshop_repair_jobs',
            'wshop_devices',
            'wshop_manufacturers',
            'wshop_models',
            'wshop_categories',
            'wshop_labour_products',
            'wshop_labour_product_materials',
            'wshop_repair_job_labour_products',
            'wshop_repair_job_labour_materials',
            'wshop_inspections',
            'wshop_inspection_values',
            'wshop_activity'
        ];
        
        $db_results = [];
        foreach ($tables as $table) {
            $exists = $CI->db->table_exists(db_prefix() . $table);
            $db_results[$table] = $exists;
        }

        // 2. Check Critical Files
        $files = [
            'models/Workshop_model.php',
            'controllers/Workshop.php',
            'helpers/workshop_helper.php',
            'views/repair_jobs/repair_job.php',
            'views/devices/manage.php'
        ];
        
        $file_results = [];
        foreach ($files as $file) {
            $path = module_dir_path('workshop', $file);
            $file_results[$file] = file_exists($path);
        }

        // 3. Check Permissions
        $permissions = [
            'workshop_repair_job',
            'workshop_device'
        ];
        $perm_results = [];
        $permissions_table = db_prefix() . 'permissions';
        
        if($CI->db->table_exists($permissions_table)){
             foreach($permissions as $perm){
                try{
                     $perm_results[$perm] = total_rows($permissions_table, ['shortname' => $perm]);
                } catch (Exception $e){
                     $perm_results[$perm] = -1; // Error code
                }
            }
        } else {
            $perm_results['Table permissions not found'] = -1;
        }
        
        // Render View Inline
        echo '<link href="//cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">';
        echo '<div class="container mt-5">';
        echo '<h1>👨‍⚕️ Workshop Doctor <small class="text-muted">System Diagnostic Tool</small></h1><hr>';
        
        echo '<div class="row">';
        
        // Database Card
        echo '<div class="col-md-4"><div class="card mb-4 shadow-sm">';
        echo '<div class="card-header bg-primary text-white">Database Integrity</div>';
        echo '<ul class="list-group list-group-flush">';
        foreach($db_results as $tbl => $status){
            $icon = $status ? '✅' : '❌';
            $cls = $status ? 'text-success' : 'text-danger';
            echo "<li class='list-group-item d-flex justify-content-between align-items-center'>$tbl <span class='$cls'>$icon</span></li>";
        }
        echo '</ul></div></div>';

        // Files Card
        echo '<div class="col-md-4"><div class="card mb-4 shadow-sm">';
        echo '<div class="card-header bg-success text-white">Critical Files</div>';
        echo '<ul class="list-group list-group-flush">';
        foreach($file_results as $f => $status){
            $icon = $status ? '✅' : '❌';
            $cls = $status ? 'text-success' : 'text-danger';
            echo "<li class='list-group-item d-flex justify-content-between align-items-center'>" . basename($f) . " <span class='$cls'>$icon</span></li>";
        }
        echo '</ul></div></div>';

        // Hooks/Permissions Card
        echo '<div class="col-md-4"><div class="card mb-4 shadow-sm">';
        echo '<div class="card-header bg-info text-white">Permissions & Config</div>';
        echo '<ul class="list-group list-group-flush">';
        foreach($perm_results as $p => $count){
             $status = $count > 0;
             $icon = $status ? '✅' : '❌';
             echo "<li class='list-group-item d-flex justify-content-between align-items-center'>Permission: $p <span>$icon</span></li>";
        }
        echo "<li class='list-group-item d-flex justify-content-between align-items-center'>Module Version <span>".VERSION_WORKSHOP."</span></li>";
        echo '</ul></div></div>';
        
        echo '</div>'; // row
        echo '<a href="'.admin_url('workshop/dashboard').'" class="btn btn-secondary mt-3">Back to Dashboard</a>';
        echo '</div>';
    }
}
